#!/usr/bin/perl
#
# Copyright 2012 Idera, Inc. 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

use warnings;
use strict;
use FindBin;
use lib "$FindBin::RealBin/";
use BuagentAuth;

my $auth_ok = 0;

my $user = <>;
chomp($user);
my $pass = <>;
chomp($pass);

my $auth_ref = BuagentAuth::auth($user, $pass);

if( $auth_ref->{auth_ok} == 1 && $auth_ref->{uid} > 500 ) {
	print "auth_ok:" . $auth_ref->{auth_ok} . "\n";
	print "uid:" . $auth_ref->{uid} . "\n";
	print "gid:" . $auth_ref->{gid} . "\n";
	print "dir:home:" . $auth_ref->{homedir} . "\n";
	exit();
}

print "auth_ok:0\n";
