#!/usr/bin/perl
#
# Copyright 2011 Idera, Inc. 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package BuagentPleskAuth;

use strict;
use DBI;
use FindBin;
use lib "$FindBin::RealBin/";
use BuagentAuth;

sub get_db_value {
	my $dbh = shift;
	my $statement = shift;
	my $sth = $dbh->prepare($statement) or die $dbh->errstr;
	$sth->execute(@_) or die $dbh->errstr;
	($sth->fetchrow_array)[0];
}

sub get_all_arrayref {
	my $dbh = shift;
	my $statement = shift;
	my $sth = $dbh->prepare($statement) or die $dbh->errstr;
	$sth->execute(@_) or die $dbh->errstr;
	$sth->fetchall_arrayref;
}

sub get_user_list {
	my $dbh = shift;
	my $statement = q{SELECT t1.login, t1.home, t3.name from sys_users AS t1, hosting AS t2, domains AS t3 WHERE t1.id = t2.sys_user_id AND t2.dom_id = t3.id;};
	my $sth = $dbh->prepare($statement) or die $dbh->errstr;
	$sth->execute(@_) or die $dbh->errstr;
	$sth->fetchall_arrayref();
}

sub get_domain {
	my $dbh = shift;
	my $username = shift;
	my $sys_user_id  = get_db_value($dbh, q{SELECT id from sys_users WHERE login=? LIMIT 1}, $username);
	my $dom_id  = get_db_value($dbh, q{SELECT dom_id from hosting WHERE sys_user_id=? LIMIT 1}, $sys_user_id);
	my $domain = get_db_value($dbh, q{SELECT name from domains WHERE id=? LIMIT 1}, $dom_id);
	$dbh->disconnect();
	$domain;
}



sub get_psa_conf {
	my %psa_conf;
	open(my $conf_file, '<', '/etc/psa/psa.conf') || die("could not open psa conf");
	while(<$conf_file>) {
		chomp;
		s/#.*//;
		my ($name, $value) = split(/\s/, $_, 2);
		$psa_conf{$name} = $value;
	}
	close($conf_file);
	return \%psa_conf;
}

#main

open(PASS, '/etc/psa/.psa.shadow');
my $pass = <PASS>;
$pass =~ s/(?:\n|\r)+?$//;
close(PASS);

my $dbh = DBI->connect('DBI:mysql:psa', 'admin', $pass) or die "Could not connect to database";

my $psa_conf_ref = get_psa_conf();

my $user = <>;
chomp($user);
my $pass = <>;
chomp($pass);
my $auth_ref = BuagentAuth::auth($user, $pass);
print "auth_ok:" . $auth_ref->{auth_ok} . "\n";
if ($auth_ref->{auth_ok} == 0) { exit; }

if (-d $auth_ref->{homedir}) {
	print "dir:home:" . $auth_ref->{homedir} . "\n";
}

my $domain = get_domain($dbh, $user);

if (defined($domain)) {

	my $mail_dir = $psa_conf_ref->{PLESK_MAILNAMES_D};

	if (!defined($mail_dir)) {
		$mail_dir = $psa_conf_ref->{QMAIL_MAILNAMES_D};
	}

	if (defined($mail_dir)) {
		my $mailnamedir = $mail_dir . "/" . $domain;
		if (-d $mailnamedir) {
			print "dir:mail:" . $mailnamedir . "\n";
		}
	}
}
