#!/usr/bin/perl
#
# Copyright 2012 Idera, Inc. 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

use warnings;
use strict;

my $passwdfile = "/etc/passwd";
my $passwd;

open($passwd, '<', $passwdfile);

while(<$passwd>) {

	my @fields = split /:/;

	next if $fields[0] eq 'root';

        my $uid = getpwnam($fields[0]);
        next if !defined($uid);
	my $upw = (getpwuid($uid))[1];
	next if !defined($upw);

	# Account is locked
	next if $upw eq 'LK';
	next if $upw eq '*';

	# Account has no password
	next if $upw eq 'NP';
	next if $upw eq '!';

	# Account has expired
	next if $upw eq '!!';

	print "$fields[0]:home:$fields[5]\n";

}

close($passwd);
